 ; Ŀ
 ;   Tech - multiple search and replace for all string type entities.      
 ;   Copyright 1994, 1999, 2001 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Nert - error handler.                                                 
 ; 
 (DEFUN NERT (shk /)
  (setq *error* esav)
  (if (/= shk "Function cancelled") (write-line shk))
  (setvar "snapmode" snapp)
  (if relst
      (while (setq next (car relst))
             (setq relst (cdr relst))
             (redraw next 4)))
 (princ))
 ; Ŀ
 ;   Nert end.                                                             
 ; 

 ; Ŀ
 ;   Tech.                                                                 
 ; 
 (DEFUN C:TECH (/ tex typ texlst chlin chnum dd cclen ddlen next enam nent
                           renam enttp relst entt pos changd outer estr chunk)
  (setvar "cmdecho" 0)
  (command "undo" "mark")
  (setq esav *error*)
  (setq *error* nert)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (while (setq tex (nentsel "\nSelect pseudotext: "))
         (setq typ (cdr (assoc 0 (setq enttp (entget (car tex))))))
         (if (or (= "TEXT" typ) (= "MTEXT" typ)
                 (= "ATTDEF" typ) (= "ATTRIB" typ))
             (progn
                  (princ (cdr (assoc 1 enttp)))
                  (redraw (setq renam (cdr (assoc -1 enttp))) 3)
                  (setq relst (cons renam relst))
                  (setq texlst (append texlst (list tex))))))
  (cond ((null texlst)
         (write-line "\nNo suitable entities selected."))
        ((and (if (= (type cc) 'STR)
                 (progn
                      (setq ccp (getstring t (strcat "\nExisting string <"
                                                                    cc ">:")))
                      (if (/= ccp "") (setq cc ccp)))
                 (progn
                      (setq cont t)
                      (while cont
                            (setq cc (getstring t "\nOld string:"))
                            (if (= cc "")
                                (princ "Can't search for nothing.")
                                (setq cont nil)))))
              ()))              ; nil - go to next cond no matter what
        ((and cc (/= cc ""))
         (setq chlin 0)
         (setq chnum 0)
         (setq dd (getstring t "Replacement string:"))
         (setq cclen (strlen cc))
         (setq ddlen (strlen dd))
         (while (setq next (car relst))
                (setq relst (cdr relst))
                (redraw next 4))
         (while (setq next (car texlst))
                (setq texlst (cdr texlst))
                (setq enam (car (setq nent next)))
                (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
                (if (or (= "TEXT" typ) (= "MTEXT" typ)
                        (= "ATTDEF" typ) (= "ATTRIB" typ))
                    (progn
                         (setq pos 1)
                         (setq changd ())
                         (setq outer (car (reverse (car (reverse nent)))))
                         (setq estr (cdr (assoc 1 entt)))
                         (while (= cclen (strlen (setq chunk
                                                     (substr estr pos cclen))))
                                (if (= chunk cc)
                                    (progn
                                        (setq estr
                                          (strcat (substr estr 1 (1- pos)) dd
                                                  (substr estr (+ pos cclen))))
                                        (setq changd t)
                                        (setq chnum (1+ chnum))
                                        (setq pos (+ pos ddlen)))
                                    (setq pos (1+ pos))))
                         (if changd
                             (progn
                                  (setq chlin (1+ chlin))
                                  (entmod (subst (cons 1 estr)
                                                 (assoc 1 entt) entt))
                                  (if (= (type outer) 'ENAME)
                                      (entupd outer)
                                      (entupd enam)))))))
         (if (< 0 chlin)
             (write-line (strcat "Changed " (itoa chnum)
                                 " instance" (if (= chnum 1) "" "s")
                                 " in " (itoa chlin)
                                 " line" (if (= chlin 1) "." "s.")))
             (write-line "No changes made."))))
  (nert "")
 (princ))